function SaveGame(file)
{
	f = OpenFile(file)
	
	for (var x = 0; x < gMap.length; x++)
		for (var y = 0; y < gMap[x].length; y++)
			f.write("gMap-"+x+"-"+y, gMap[x][y])
			
	for (var x = 0; x < gMapLink.length; x++)
		for (var y = 0; y < gMapLink[x].length; y++)
			f.write("gMapLink-"+x+"-"+y, gMapLink[x][y]	)
			
	for (var i = 0; i < gPlayer_Mushrooms.length; i++)
		{
			f.write("PMUSH-"+i, gPlayer_Mushrooms[i].type)
		}
		
	f.write("FLAG_LENGTH", gFlags.length);	
		
	for (var i = 0; i < gFlags.length; i++)
		{
			f.write("FLAG-"+i, gFlags[i])
		}
		
	f.write("PMUSH_LENGTH", gPlayer_Mushrooms.length)
		
	if (gPlayer_Ship != -1)
		{
			f.write("SHIP", true)
			f.write("SHIP_IMAGE", gPlayer_Ship.base_image)
			
			f.write("SHIP_LENGTH", gPlayer_Ship.mushrooms.length )
			
			for (var i = 0; i < gPlayer_Ship.mushrooms.length; i++)
				{
					f.write("SHIP_MUSH_TYPE-"+i, gPlayer_Ship.mushrooms[i].type)
					f.write("SHIP_MUSH_LINKED-"+i, gPlayer_Ship.mushrooms[i].linked)
					f.write("SHIP_MUSH_HP-"+i, gPlayer_Ship.mushrooms[i].hp)
					f.write("SHIP_MUSH_X-"+i, gPlayer_Ship.mushrooms[i].x)
					f.write("SHIP_MUSH_Y-"+i, gPlayer_Ship.mushrooms[i].y)
				}
		}
	else
		{
			f.write("SHIP", false)
		}
			
	f.write("MAPX", gMapX)
	f.write("MAPY", gMapY)
	
	f.write("GOLD", gPlayer_Gold)
	f.write("LEVEL", gPlayer_Level)
	
	f.write("MAP", GetCurrentMap() )
	f.write("WALKX", GetPersonX("player") )
	f.write("WALKY", GetPersonY("player") )
	
	f.write("KEYS", gPlayerKeys )
	
	f.flush()
}

function LoadGame(file)
{
	f = OpenFile(file)
	
	for (var x = 0; x < gMap.length; x++)
		for (var y = 0; y < gMap[x].length; y++)
			gMap[x][y] = f.read("gMap-"+x+"-"+y, -1)
			
	//Abort( f.read("gMap-"+0+"-"+1, -1) )	
			
	for (var x = 0; x < gMapLink.length; x++)
		for (var y = 0; y < gMapLink[x].length; y++)
			gMapLink[x][y] = f.read("gMapLink-"+x+"-"+y, -1)		
			
	var length = f.read("FLAG_LENGTH", 0)		
			
	for (var i = 0; i < gFlags.length; i++)
		{
			gFlags[i] = f.read("FLAG-"+i, gFlags[i])
		}			
	
	length = f.read("PMUSH_LENGTH", 0)
			
	for (var i = 0; i < length; i++)
		{
			gPlayer_Mushrooms.push( new ItemBuild_oBlock(0, 0, f.read("PMUSH-"+i, 0)) ) 
		}
		
	if (f.read("SHIP", false))
		{
			var base_img = f.read("SHIP_IMAGE", "bg.png")
			
			var mush = new Array()
			
			length =  f.read("SHIP_LENGTH", 0)
			
			var type, linked, hp, x, y
			
			for (var i = 0; i < length; i++)
				{
					x = f.read("SHIP_MUSH_X-"+i, 0)
					y = f.read("SHIP_MUSH_Y-"+i, 0)
					type = f.read("SHIP_MUSH_TYPE-"+i, 0)
					hp = f.read("SHIP_MUSH_HP-"+i, 0)
					linked = f.read("SHIP_MUSH_LINKED-"+i, false)
				
					mush.push ( new ItemBuild_oBlock(x, y, type) )
					
					mush[i].hp = hp
					
					mush[i].linked = linked
				}
				
			gPlayer_Ship = new oShip(base_img, mush, [])	
			
			gPlayer_Ship.RegenerateShipData()
		}
	else
		{
			gPlayer_Ship = -1
		}
			
	gMapX = f.read("MAPX", -1)
	gMapY = f.read("MAPY", -1)
	
	gPlayer_Gold = f.read("GOLD", 0)
	gPlayer_Level = f.read("LEVEL", 0)
	
	var map = f.read("MAP", "intro.rmp" )
	var x = f.read("WALKX", -1 )
	var y = f.read("WALKY", -1 )
	
	gPlayerKeys = f.read("KEYS", 0)
	
	xy = PixelToTile(x,y)
	
	f.close()
	
	SwapWalkMap(map, xy[0], xy[1])
}

function LoadGame1() { LoadGame("game1.sav"); CloseWindows(); }
function LoadGame2() { LoadGame("game2.sav"); CloseWindows(); }
function LoadGame3() { LoadGame("game3.sav"); CloseWindows(); }

function SaveGame1() { SaveGame("game1.sav"); CloseWindows(); }
function SaveGame2() { SaveGame("game2.sav"); CloseWindows(); }
function SaveGame3() { SaveGame("game3.sav"); CloseWindows(); }

function menu_Load()
{
	
	gSuspendMovement = true
	
	var pos = gMenuContainer.menus[0].children[0].pos
		
	gMenuContainer = new menu_oContainer(1,0)
			
	gMenuContainer.on = true

	gMenuContainer.menus.push( new menu_oMenu(0, -2, STYLE_VERTICAL, "style.rws", 
														BasicMenuUpdate, NoWindowMenuRender) )
			
	gMenuContainer.menus.push( new menu_oMenu(120, 120, STYLE_VERTICAL, "style.rws", 
																								BasicMenuUpdate, BasicMenuRender) )
																								
	gMenuContainer.menus.push( new menu_oMenu(0, -2, STYLE_VERTICAL, "style.rws", 
														BasicMenuUpdate, NoWindowMenuRender) )																								
																								
	gMenuContainer.menus[1].AddChild( new menu_oChild_Option("Slot 1", LoadGame1) )
	if (!FileCheck("game1.sav"))
		gMenuContainer.menus[1].children[gMenuContainer.menus[1].children.length-1].selectable = false;
	gMenuContainer.menus[1].AddChild( new menu_oChild_Option("Slot 2", LoadGame2) )
	if (!FileCheck("game2.sav"))
		gMenuContainer.menus[1].children[gMenuContainer.menus[1].children.length-1].selectable = false;	
	gMenuContainer.menus[1].AddChild( new menu_oChild_Option("Slot 3", LoadGame3) )	
	if (!FileCheck("game3.sav"))
		gMenuContainer.menus[1].children[gMenuContainer.menus[1].children.length-1].selectable = false;	
	gMenuContainer.menus[1].AddChild( new menu_oChild_Option("Cancel", MainMenu) )																								

	gMenuContainer.menus[0].AddChild( new menu_oChild_ScrollImage( GetImage("bg2.png") ) )
	
	gMenuContainer.menus[0].children[0].pos = pos
	
	gMenuContainer.menus[2].AddChild( new menu_oChild_Image( GetImage("title.png") ) )	
}

function FileCheck(file)
{
	f = OpenFile(file);
	
	if (f.read("FLAG-0", -1) != -1) return true
	else { return false}
}

function menu_Save()
{
	gSuspendMovement = true
		
	gMenuContainer = new menu_oContainer(0,0)
			
	gMenuContainer.on = true
			
	gMenuContainer.menus.push( new menu_oMenu(20, 20, STYLE_VERTICAL, "style.rws", 
																								BasicMenuUpdate, BasicMenuRender) )
																								
	gMenuContainer.menus[0].AddChild( new menu_oChild_Option("Slot 1", SaveGame1) )
	gMenuContainer.menus[0].AddChild( new menu_oChild_Option("Slot 2", SaveGame2) )
	gMenuContainer.menus[0].AddChild( new menu_oChild_Option("Slot 3", SaveGame3) )	
	gMenuContainer.menus[0].AddChild( new menu_oChild_Option("Cancel", CloseWindows) )	
}